QT += core gui widgets opengl openglwidgets
greaterThan(QT_MAJOR_VERSION, 4): QT += widgets

# CONFIG += c++17
CONFIG += c++11 release

# WebAssembly configuration
wasm {
    message("Building for WebAssembly")

    # WebAssembly-specific settings
    QMAKE_LFLAGS += -s TOTAL_MEMORY=268435456           # 256 MB initial memory
    QMAKE_LFLAGS += -s ALLOW_MEMORY_GROWTH=1            # Allow memory growth
    QMAKE_LFLAGS += -s MAX_WEBGL_VERSION=2              # Use WebGL 2.0
    QMAKE_LFLAGS += -s FULL_ES3=1                       # Full OpenGL ES 3.0 support
    QMAKE_LFLAGS += -s USE_WEBGL2=1                     # Enable WebGL 2
    QMAKE_LFLAGS += -s WASM=1                           # Enable WebAssembly
    QMAKE_LFLAGS += -s EXPORTED_RUNTIME_METHODS=['UTF16ToString','stringToUTF16']

    # Optimization flags for release build
    CONFIG(release, debug|release) {
        message("WebAssembly Release Build")
        QMAKE_LFLAGS += -O3                             # Maximum optimization
        QMAKE_LFLAGS += -s ASSERTIONS=0                 # Disable assertions
        QMAKE_CXXFLAGS += -O3                           # C++ optimization
    }

    # Debug flags for debug build
    CONFIG(debug, debug|release) {
        message("WebAssembly Debug Build")
        QMAKE_LFLAGS += -g                              # Include debug info
        QMAKE_LFLAGS += -s ASSERTIONS=1                 # Enable assertions
        QMAKE_LFLAGS += -s SAFE_HEAP=1                  # Enable heap safety checks
        QMAKE_LFLAGS += -s STACK_OVERFLOW_CHECK=1       # Enable stack checks
    }

    # WebAssembly HTML shell template (use our custom app.html)
    QMAKE_LFLAGS += --shell-file $$PWD/app.html

    # Additional optimization options
    QMAKE_LFLAGS += -s FILESYSTEM=1                     # Enable file system support
    QMAKE_LFLAGS += -s FETCH=1                          # Enable Fetch API
    QMAKE_LFLAGS += -s MODULARIZE=1                     # Modular output
    QMAKE_LFLAGS += -s EXPORT_NAME='createQtAppInstance' # Export name

    # Enable ASYNCIFY for async operations (required for QFileDialog)
    QMAKE_LFLAGS += -s ASYNCIFY=1                       # Enable async/await support
    QMAKE_LFLAGS += -s ASYNCIFY_STACK_SIZE=24576        # Stack size for async operations

    # Threading support (optional, requires HTTPS)
    # Uncomment to enable threads (requires SharedArrayBuffer)
    #QMAKE_LFLAGS += -s USE_PTHREADS=1
    #QMAKE_LFLAGS += -s PTHREAD_POOL_SIZE=4

    # SIMD support (optional, for newer browsers)
    # Uncomment to enable SIMD optimizations
    #QMAKE_LFLAGS += -msimd128

    # Copy WebAssembly deployment files to output directory
    wasm_files.files = $$PWD/app.html $$PWD/qtloader.js $$PWD/qtlogo.svg
    wasm_files.path = $$OUT_PWD
    INSTALLS += wasm_files
}

# You can make your code fail to compile if it uses deprecated APIs.
# In order to do so, uncomment the following line.
#DEFINES += QT_DISABLE_DEPRECATED_BEFORE=0x060000    # disables all the APIs deprecated before Qt 6.0.0

SOURCES += \
    main.cpp \
    MainWindow.cpp \
    GLViewport.cpp \
    math/Vec3.cpp \
    math/Matrix4.cpp \
    math/Quaternion.cpp \
    mesh/Mesh.cpp \
    mesh/MeshGenerator.cpp \
    sdf/SDFEngine.cpp \
    sdf/SDFPrimitives.cpp \
    algorithms/AlgorithmLibrary.cpp \
    algorithms/FractalGenerators.cpp \
    algorithms/GearGenerator.cpp \
    algorithms/PatternGenerator.cpp \
    algorithms/PointCloudMeshing.cpp \
    optimization/CMAESOptimizer.cpp \
    optimization/NSGAIIOptimizer.cpp \
    optimization/RBFOptimizer.cpp \
    neuralnet/NeuralNetwork.cpp \
    neuralnet/CPPNHyperNEAT.cpp \
    animation/VertexAnimator.cpp \
    export/FBXExporter.cpp \
    export/MeshExporter.cpp \
    voxel/VoxelGenerator.cpp \
    utils/ImageToSurface.cpp

HEADERS += \
    MainWindow.h \
    GLViewport.h \
    math/Vec3.h \
    math/Matrix4.h \
    math/Quaternion.h \
    mesh/Mesh.h \
    mesh/MeshGenerator.h \
    sdf/SDFEngine.h \
    sdf/SDFPrimitives.h \
    algorithms/AlgorithmLibrary.h \
    algorithms/FractalGenerators.h \
    algorithms/GearGenerator.h \
    algorithms/PatternGenerator.h \
    algorithms/PointCloudMeshing.h \
    optimization/CMAESOptimizer.h \
    optimization/NSGAIIOptimizer.h \
    optimization/RBFOptimizer.h \
    neuralnet/NeuralNetwork.h \
    neuralnet/CPPNHyperNEAT.h \
    animation/VertexAnimator.h \
    export/FBXExporter.h \
    export/MeshExporter.h \
    voxel/VoxelGenerator.h \
    utils/ImageToSurface.h

RESOURCES += \
    resources.qrc

# Default rules for deployment.
qnx: target.path = /tmp/$${TARGET}/bin
else: unix:!android: target.path = /opt/$${TARGET}/bin
!isEmpty(target.path): INSTALLS += target

# LIBS += -lopengl32
TARGET = mesher
