#pragma once
#include "../mesh/Mesh.h"
#include "../math/Vec3.h"
#include <complex>

class FractalGenerators {
public:
    static Mesh mandelbrot3D(int resolution, float threshold, int maxIterations);
    static Mesh julia3D(const std::complex<float>& c, int resolution, int maxIterations);
    static Mesh sierpinskiTetrahedron(int iterations, float size);
    static Mesh mengerSponge(int iterations, float size);
    static Mesh kochSnowflake3D(int iterations, float size, float height);
    static Mesh dragoncurve3D(int iterations, float size);
};
