#include "GearGenerator.h"
#include "../mesh/MeshGenerator.h"

Mesh GearGenerator::createSpurGear(int teeth, float module, float thickness, float pressureAngle) {
    float pitchRadius = module * teeth / 2.0f;
    float addendum = module;
    float outerRadius = pitchRadius + addendum;

    Mesh mesh;
    int segmentsPerTooth = 8;

    for (int t = 0; t < teeth; t++) {
        for (int s = 0; s < segmentsPerTooth; s++) {
            float angle = 2.0f * M_PI * (t + (float)s / segmentsPerTooth) / teeth;
            float r = (s < segmentsPerTooth / 2) ? outerRadius : pitchRadius;

            mesh.addVertex(Vertex(Vec3(r * std::cos(angle), 0, r * std::sin(angle))));
            mesh.addVertex(Vertex(Vec3(r * std::cos(angle), thickness, r * std::sin(angle))));
        }
    }

    mesh.computeNormals();
    return mesh;
}

Mesh GearGenerator::createBevelGear(int teeth, float module, float coneAngle, float faceWidth) {
    return createSpurGear(teeth, module, faceWidth, 20.0f);
}

Mesh GearGenerator::createWormGear(float leadAngle, int threads, float diameter, float length) {
    return MeshGenerator::createCylinder(diameter / 2, length, 32);
}

Mesh GearGenerator::createPlanetaryGearSystem(int sunTeeth, int planetTeeth, int ringTeeth) {
    Mesh system = createSpurGear(sunTeeth, 1.0f, 0.5f);
    return system;
}
