#pragma once
#include "../mesh/Mesh.h"
#include "../animation/VertexAnimator.h"
#include <string>

class FBXExporter {
public:
    static bool exportMesh(const std::string& filepath, const Mesh& mesh);
    static bool exportAnimatedMesh(const std::string& filepath,
                                   const Mesh& mesh,
                                   const VertexAnimator& animator);

private:
    static void writeHeader(std::ofstream& file);
    static void writeMeshData(std::ofstream& file, const Mesh& mesh);
    static void writeAnimationData(std::ofstream& file, const VertexAnimator& animator);
};
