#include "Mesh.h"

void Mesh::getBounds(Vec3& min, Vec3& max) const {
    if (vertices.empty()) {
        min = Vec3(0, 0, 0);
        max = Vec3(0, 0, 0);
        return;
    }
    
    min = vertices[0].position;
    max = vertices[0].position;
    
    for (const auto& vertex : vertices) {
        const Vec3& pos = vertex.position;
        
        min.x = std::min(min.x, pos.x);
        min.y = std::min(min.y, pos.y);
        min.z = std::min(min.z, pos.z);
        
        max.x = std::max(max.x, pos.x);
        max.y = std::max(max.y, pos.y);
        max.z = std::max(max.z, pos.z);
    }
}

void Mesh::clear() {
    vertices.clear();
    vertices.shrink_to_fit();
    
    triangles.clear();
    triangles.shrink_to_fit();
    
    name = "";
}
