#pragma once
#include <vector>
#include <functional>

class CMAESOptimizer {
public:
    using ObjectiveFunction = std::function<double(const std::vector<double>&)>;

    CMAESOptimizer(int dimension, double sigma = 0.5);

    std::vector<double> optimize(ObjectiveFunction func, int maxIterations = 1000);

    void setPopulationSize(int size) { populationSize = size; }
    void setSigma(double s) { sigma = s; }

private:
    int dimension;
    int populationSize;
    double sigma;
    std::vector<double> mean;
    std::vector<std::vector<double>> covarianceMatrix;
};
