#pragma once
#include <vector>
#include <functional>

class RBFOptimizer {
public:
    using ObjectiveFunction = std::function<double(const std::vector<double>&)>;

    RBFOptimizer(int dimension);

    std::vector<double> optimize(ObjectiveFunction func, int maxEvaluations = 500);

    void setBounds(const std::vector<double>& lower, const std::vector<double>& upper);

private:
    int dimension;
    std::vector<double> lowerBounds;
    std::vector<double> upperBounds;

    double rbfKernel(const std::vector<double>& x1, const std::vector<double>& x2);
    std::vector<double> selectNextPoint(const std::vector<std::vector<double>>& evaluated);
};
