#include "ImageToSurface.h"
#include "../mesh/MeshGenerator.h"

std::vector<std::vector<float>> ImageToSurface::loadImageData(const std::string& imagePath) {
    // Simplified: would use image loading library (Qt, stb_image, etc.)
    std::vector<std::vector<float>> data(64, std::vector<float>(64, 0.5f));
    return data;
}

Mesh ImageToSurface::loadHeightmap(const std::string& imagePath, float heightScale) {
    auto heightData = loadImageData(imagePath);
    return generateFromGrayscale(heightData, heightScale);
}

Mesh ImageToSurface::generateFromGrayscale(const std::vector<std::vector<float>>& heightData, float heightScale) {
    if (heightData.empty() || heightData[0].empty()) {
        return Mesh();
    }

    int height = heightData.size();
    int width = heightData[0].size();

    Mesh mesh;

    for (int y = 0; y < height; y++) {
        for (int x = 0; x < width; x++) {
            float h = heightData[y][x] * heightScale;
            float px = (float)x / width * 10.0f - 5.0f;
            float pz = (float)y / height * 10.0f - 5.0f;

            mesh.addVertex(Vertex(Vec3(px, h, pz)));
        }
    }

    for (int y = 0; y < height - 1; y++) {
        for (int x = 0; x < width - 1; x++) {
            int i0 = y * width + x;
            int i1 = i0 + 1;
            int i2 = i0 + width;
            int i3 = i2 + 1;

            mesh.addTriangle(i0, i2, i1);
            mesh.addTriangle(i1, i2, i3);
        }
    }

    mesh.computeNormals();
    return mesh;
}
