#pragma once
#include "../mesh/Mesh.h"
#include <string>
#include <vector>

class ImageToSurface {
public:
    static Mesh loadHeightmap(const std::string& imagePath, float heightScale = 1.0f);
    static Mesh generateFromGrayscale(const std::vector<std::vector<float>>& heightData, float heightScale);

private:
    static std::vector<std::vector<float>> loadImageData(const std::string& imagePath);
};
